/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *   and Andreas Bresser bresser@informatik.uni-bremen.de                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "CSVLogger.h"

CSVLogger::CSVLogger(cSettings * settings, sMode * mode)
{
    // QFile-Instanz (Log-Datei)
    csvfile = new QFile("");
    this->settings = settings;
    this->mode = mode;
}

CSVLogger::~CSVLogger()
{
    close();
}

//datei ist geöffnet bedeutet wir sind soweit und können schreiben
bool CSVLogger::ready()
{
    return csvfile->isOpen();
}

//Datei schließen
void CSVLogger::close()
{
    if (csvfile->isOpen())
        csvfile->close();
}

//neuen Log erstellen
void CSVLogger::newLog()
{
    if (!csvfile->isOpen())
    {
        QString mode_name = mode->Hardware;

        if (mode_name.size() == 0)
        {
            mode_name = QString("groundstation_log");
        }

        QString filename = settings->DIR.Logging + mode_name + "_" +
                           QDate::currentDate().toString(("yyyy-MM-dd")) + "_" +
                           QTime::currentTime().toString("hh-mm") + ".csv";

        csvfile = new QFile(filename);

        if (!csvfile->exists())
        {
            csvfile->open(QIODevice::Append | QIODevice::Text);

            QTextStream Out(csvfile);

            for (int a = 0; a < MaxAnalog; a++)
            {
                if (settings->Analog1.LogView[a])
                {
                    Out << settings->Analog1.Label[a];

                    if (a < MaxAnalog - 1)
                        Out << ';';
                }
            }
            Out << "\n";
        }
        else
        {
            csvfile->open(QIODevice::Append | QIODevice::Text);
        }
    }
}

//daten schreiben
void CSVLogger::write(int * analogData)
{
    if (csvfile->isOpen())
    {
        QTextStream out(csvfile);
        for (int a=0; a<MaxAnalog; a++)
        {
            if (settings->Analog1.LogView[a])
            {
                out << analogData[a];
                if (a < MaxAnalog - 1)
                    out << ';';
            }
        }
        out << "\n";
    }
}
